#!/usr/bin/env  python
__license__     = 'GPL v3'
__author__      = 'Lorenzo Vigentini'
__copyright__   = '2009, Lorenzo Vigentini <l.vigentini at gmail.com>'
__version__     = 'v1.01'
__date__        = '14, January 2010'
__description__ = 'PC World and Macworld consistently deliver editorial excellence through award-winning content and trusted product reviews.'

'''
http://www.pcworld.com/
'''

from calibre.web.feeds.news import BasicNewsRecipe
from calibre.ptempfile import PersistentTemporaryFile

temp_files = []
articles_are_obfuscated = True

class pcWorld(BasicNewsRecipe):
    __author__    = 'Lorenzo Vigentini'
    description   = 'PC World and Macworld consistently deliver editorial excellence through award-winning content and trusted product reviews.'
    cover_url     = 'http://images.pcworld.com/images/common/header/header-logo.gif'

    title          = 'PCWorld '
    publisher      = 'IDG Communication'
    category       = 'PC, video, computing, product reviews, editing, cameras, production'

    language       = 'en'
    timefmt        = '[%a, %d %b, %Y]'

    oldest_article        = 7
    max_articles_per_feed = 100
    use_embedded_content  = False
    recursion             = 10

    remove_javascript     = True
    no_stylesheets        = True
    extra_css = '''
        h1{font-family:Georgia,serif; font-weight:bold;font-size:large;}
        h2{font-family:Georgia,serif; font-weight:normal;font-size:small;}
        p{font-family:Georgia,serif;font-size:small;}
        body{font-family:Georgia,serif;font-size:small;}
        '''

    def get_obfuscated_article(self, url):
        br = self.get_browser()
        br.open(url+'&print')

        response = br.follow_link(url, nr = 0)
        html = response.read()

        self.temp_files.append(PersistentTemporaryFile('_fa.html'))
        self.temp_files[-1].write(html)
        self.temp_files[-1].close()
        return self.temp_files[-1].name

    keep_only_tags     = [
                            dict(name='div', attrs={'class':'article'})
                        ]

    remove_tags        = [
                            dict(name='div', attrs={'class':['toolBar','mac_tags','toolBar  btmTools','recommend longRecommend','recommend shortRecommend','textAds','module miniCap radius_3']}),
                            dict(name='div', attrs={'id':['sidebar','comments','mac_tags','breadcrumbs']}),
                            dict(name='ul', attrs={'class':['tools','tools clearfix']}),
                            dict(name='li', attrs={'class':'sub'}),
                            dict(name='p', attrs={'id':'userDesire'}),
                            dict(name='img')
                        ]

    feeds          = [
                       (u'PCWorld Headlines', u'http://feeds.pcworld.com/pcworld/latestnews'),
                       (u'How-To', u'http://feeds.pcworld.com/pcworld/update/howto'),
                       (u'Today@PCWorld', u'http://feeds.pcworld.com/pcworld/blogs/todayatpcw'),
                       (u'Reviews', u'http://feeds.pcworld.com/pcworld/update/reviews'),
                       (u'Answer Lines', u'http://feeds.pcworld.com/pcworld/blogs/answer_line'),
                       (u'Digital Focus', u'http://feeds.pcworld.com/pcworld/blogs/digital_focus'),
                       (u'Geek tech', u'http://feeds.pcworld.com/pcworld/blogs/geektech/'),
                       (u'Hassle free PC', u'http://feeds.pcworld.com/pcworld/blogs/hassle-free_pc'),
                       (u'Mobile computing', u'http://feeds.pcworld.com/pcworld/blogs/mobile_computing'),
                       (u'Security alert', u'http://feeds.pcworld.com/pcworld/blogs/security_alert/'),
                       (u'The Cost Cutter', u'http://feeds.pcworld.com/pcworld/businesscenter/cost_cutter/'),
                       (u'Net Work', u'http://feeds.pcworld.com/pcworld/businesscenter/network/'),
                       (u'Peer-to-Peer', u'http://feeds.pcworld.com/pcworld/businesscenter/peertopeer/'),
                       (u'Tech inciter', u'http://feeds.pcworld.com/pcworld/businesscenter/tech_inciter/'),
                       (u'Gadgets and gear', u'http://feeds.pcworld.com/pcworld/update/gadgets'),
                       (u'Home Entertainment', u'http://feeds.pcworld.com/pcworld/update/home-entertainment'),
                       (u'Mobile Devices', u'http://feeds.pcworld.com/pcworld/update/mobile-devices')
                     ]

      
    def preprocess_html(self, soup):
        for alink in soup.findAll('a'):
            if alink.string is not None:
               tstr = alink.string
               alink.replaceWith(tstr)
        return soup
		